#ifndef ZMODELER_STRUCT_MATRIX_H_INCLUDED
#define ZMODELER_STRUCT_MATRIX_H_INCLUDED

//--------------------------------------------------
// Some matrix functions. (new in ZM 1.06)
//--------------------------------------------------
typedef struct
{
  union
  {
    float _matrix[16];
    struct
    {
      float _11, _12, _13, _14,
            _21, _22, _23, _24,
            _31, _32, _33, _34,
            _41, _42, _43, _44;
    };
    float m[4][4];
  };
}tMATRIX;

DllExport void SetMatrixXVector(tMATRIX& mat, tPOINT& x);
DllExport void SetMatrixYVector(tMATRIX& mat, tPOINT& y);
DllExport void SetMatrixZVector(tMATRIX& mat, tPOINT& z);
DllExport void SetMatrixPosition(tMATRIX& mat, tPOINT& pos);
DllExport tPOINT GetMatrixXVector(tMATRIX& mat);
DllExport tPOINT GetMatrixYVector(tMATRIX& mat);
DllExport tPOINT GetMatrixZVector(tMATRIX& mat);
DllExport tPOINT GetMatrixPosition(tMATRIX& mat);

// tries to normalize a vector. returnfs FALSE on near-zero length of vector.
DllExport BOOL  NormalizeVector(tPOINT& p);

// produces dot-product (scalar multiply)
DllExport float DotProduct(const tPOINT& p1, const tPOINT& p2);

// produces non-normalized cross-product (vector multiply)
DllExport tPOINT CrossProduct(const tPOINT& v1, const tPOINT& v2);

// sets matrix to identity
DllExport void SetIdentityMatrix(tMATRIX& mat);

// tries to set view matrix.
DllExport BOOL SetViewMatrix(tMATRIX& mat, tPOINT& vFrom, tPOINT& vAt, tPOINT& vUp);

// tries to set projection matrix
DllExport BOOL SetProjectionMatrix(tMATRIX& mat, float fFOV, float fAspect, float fNearPlane, float fFarPlane);

// multiplies marixes a*b
DllExport void MatrixMultiply(tMATRIX& result, tMATRIX& a, tMATRIX& b);

// tries to invert source matrix
DllExport BOOL MatrixInvert(tMATRIX& dest, tMATRIX& src);

// multiplies point to matrix
DllExport BOOL TransformPoint(tPOINT& dest, tPOINT& src, tMATRIX& mat);

#endif /*ZMODELER_STRUCT_LIST_H_INCLUDED*/
